/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.portal.ui.internal.startpage;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.portal.ui.PortalUIPlugin;
import com.aptana.portal.ui.internal.startpage.Messages;
import com.aptana.portal.ui.internal.startpage.StartPageUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.progress.UIJob;

public class StartPageStartup
implements IStartup {
    public void earlyStartup() {
        if (EclipseUtil.isTesting()) {
            return;
        }
        UIJob job = new UIJob(Messages.StartPageStartup_launchingStartPage){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String[] args = Platform.getCommandLineArgs();
                List files = FileUtil.gatherFilesFromCommandLineArguments((String[])args);
                if (files != null && files.size() > 0) {
                    IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)"Skipping Studio's start page: files on the command line.", (String)"com.aptana.portal.ui/debug/startpage");
                    for (File file : files) {
                        IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)MessageFormat.format("Loading:{0}", file.getAbsolutePath()));
                    }
                    return Status.CANCEL_STATUS;
                }
                if (EclipseUtil.isSystemPropertyEnabled((String)"studio.hideStartPage")) {
                    IdeLog.logInfo((Plugin)PortalUIPlugin.getDefault(), (String)"Skipping Studio's start page: command line flag invoked", (String)"com.aptana.portal.ui/debug/startpage");
                    return Status.CANCEL_STATUS;
                }
                if (EclipseUtil.isSystemPropertyEnabled((String)"studio.forceStartPage") || StartPageUtil.shouldShowStartPage()) {
                    StartPageUtil.showStartPage(true);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule(500L);
    }
}

